package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bClsEstilosExcel;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResCentroSindExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bResCentroSindicato.xls";
		InputStream inputStream = W83bTablaResCentroSindExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List lista = (ArrayList)contexto.get("w83bListadoResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
         
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)6);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        	
        
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)6); 
        
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    		sheet.addMergedRegion(new Region(10,Short.parseShort("6"),10,Short.parseShort("11")));//NOPMD
    	}	
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)6);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)4); 
        if(StringUtils.isEmpty(resultadoBean.getAnoRegDefDesde())){
        	resultadoBean.setAnoRegDefDesde("-");
        }
		
		StringBuffer sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
		
		if(StringUtils.isEmpty(resultadoBean.getNumRegDefDesde())){
			sb.append("-");
		}else{
			String valor=W83bUtilidadesComunes.rellenarCeros(resultadoBean.getNumRegDefDesde());
			sb.append(valor);
		} 
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoRegDefDesde()+"/"+sb.toString());
        
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("4"),11,Short.parseShort("5")));//NOPMD
	 		cell=row.createCell((short)5);
	 		 
		}
        cell = row.getCell((short)10); 
        if(StringUtils.isEmpty(resultadoBean.getAnoRegDefHasta())){
        	resultadoBean.setAnoRegDefHasta("-");
        }
		
		sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
		if(StringUtils.isEmpty(resultadoBean.getNumRegDefHasta())){
			sb.append("-");
		}else{
			String valor=W83bUtilidadesComunes.rellenarCeros(resultadoBean.getNumRegDefHasta());
			sb.append(valor);
		} 
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoRegDefHasta()+"/"+sb.toString());
       
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("10"),11,Short.parseShort("11")));//NOPMD
	 		cell=row.createCell((short)11);
	 	
		}
        
        cell = row.getCell((short)19); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("19"),11,Short.parseShort("20")));//NOPMD
	 		cell=row.createCell((short)20);
	 	
		}
        
        
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)4); 
        if(StringUtils.isEmpty(resultadoBean.getAnoActaDesde())){
        	resultadoBean.setAnoActaDesde("-");
        }
        sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
		if ("".equals(resultadoBean.getNumActaDesde())){
			sb.append("-");
		}else{
			String valor=W83bUtilidadesComunes.rellenarCeros(resultadoBean.getNumActaDesde());
			sb.append(valor);
		} 
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaDesde()+"/"+sb.toString());
     
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("4"),12,Short.parseShort("5")));//NOPMD
	 		cell=row.createCell((short)5);
	 	
		}
        cell = row.getCell((short)10); 
        if(StringUtils.isEmpty(resultadoBean.getAnoActaHasta())){
           	resultadoBean.setAnoActaHasta("-");
        }
		sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
		if(StringUtils.isEmpty(resultadoBean.getNumActaHasta())){
			sb.append("-");
		}else{
			String valor=W83bUtilidadesComunes.rellenarCeros(resultadoBean.getNumActaHasta());
			sb.append(valor);
		} 
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaHasta()+"/"+sb.toString());
        
       
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("10"),12,Short.parseShort("11")));//NOPMD
	 		cell=row.createCell((short)11);
	 		
		}
        cell = row.getCell((short)19); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
       
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("19"),12,Short.parseShort("20")));//NOPMD
	 		cell=row.createCell((short)20);
	 		
		}
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)

        String acta="";
        int otros=0;
        int contador=0;
        int total=0;
        int totalELA=0;
        int totalCCOO=0;
        int totalUGT=0;
        int totalLAB=0;
        int totalUSO=0;
        int totalCUIS=0;
        int totalCTS=0;
        int totalCSI=0;
        int totalNOSIN=0;
        int totalOTROS=0;
        int totalElec=0;
        int anno=0;
        
        int tELA=0;
        int tCCOO=0;
        int tUGT=0;
        int tLAB=0;
        int tUSO=0;
        int tCUIS=0;
        int tCTS=0;
        int tCSI=0;
        int tNOSIN=0;
        
        HashMap mapa = new HashMap();
		mapa.put("idioma", (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		mapa.put("querie", "resCentroSindicato");
        
        for(int i=0;i<lista.size();i++){
        	W83bResultadosBean bean = new W83bResultadosBean().rowToBean((HashMap)lista.get(i),mapa);//NOPMD
        	if (bean.getCodsindicato()!=null){
        		if (!acta.equals(bean.getNacta())||anno!=Integer.parseInt(bean.getAnoacta())){
	        		if (i>0&&row.getRowNum()>=16){
	        			cell = row.createCell((short)21); 
	                	cell.setCellValue(total);
	                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
	        		}
	        		total=0;
	        		otros=0;
	        		tELA=0;
	                tCCOO=0;
	                tUGT=0;
	                tLAB=0;
	                tUSO=0;
	                tCUIS=0;
	                tCTS=0;
	                tCSI=0;
	                tNOSIN=0;
	        		row = sheet.createRow((short)16+contador); // Creacin de la fila 1
	            	
	            	cell = row.createCell((short)0); 
	            	sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
	            	String valor=W83bUtilidadesComunes.rellenarCeros(bean.getNacta());
	    			sb.append(valor);
	            	cell.setCellValue(bean.getTerritorio()+"/"+bean.getAnoacta()+"/"+sb.toString());
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)1); 
	            	sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
	            	if (bean.getNregdef()!=null){
	            		valor=W83bUtilidadesComunes.rellenarCeros(bean.getNregdef());
	        			sb.append(valor);
	            	}
	            	else{
	            		sb.append("-");
	            	}
	            	if (bean.getAnoregdef()==null){
	            		bean.setAnoregdef("-");
	            	}
	            	
	            	if(StringUtils.isNotEmpty(bean.getTerritorio()) &&
	            			StringUtils.isNotEmpty(bean.getAnoregdef()) ){
	            	
	            		cell.setCellValue(bean.getTerritorio()+"/"+bean.getAnoregdef()+"/"+sb.toString());
	            	
	            	}
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)2); 
	            	if(StringUtils.isNotEmpty(bean.getFelec())){
	            		cell.setCellValue(bean.getFelec());
	            	}
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)3); 
	            	if(StringUtils.isNotEmpty(bean.getCif())){
	            		cell.setCellValue(bean.getCif());
	            	}
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)4); 
	            	if(StringUtils.isNotEmpty(bean.getSector())){
	            		cell.setCellValue(bean.getSector());
	            	}
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)5); 
	            	cell2 = row.createCell((short)6); 
	            	sheet.addMergedRegion(new Region((short)16+contador,(short)5,(short)16+contador,(short)6));//NOPMD
	            	if(StringUtils.isNotEmpty(bean.getRazon())){
	            		cell.setCellValue(bean.getRazon());
	            	}
	            	cell.setCellStyle(estiloFila(contador,excel));
	            	cell2.setCellStyle(estiloFila(contador,excel));
	            	
	            	cell = row.createCell((short)7); 
	            	if(StringUtils.isNotEmpty(bean.getNcentro())){
	            		cell.setCellValue(W83bUtilidades.numero(bean.getNcentro()));
	            	}
	            	cell.setCellStyle(styleCentrado(contador,excel));
	            	
	            	cell = row.createCell((short)8); 
	            	cell2 = row.createCell((short)9); 
	            	if(StringUtils.isNotEmpty(bean.getConvdesc())){
	            		cell.setCellValue(bean.getConvdesc());
	            	}
	            	cell.setCellStyle(estiloFila(contador,excel));
	            	cell2.setCellStyle(estiloFila(contador,excel));
	            	sheet.addMergedRegion(new Region((short)16+contador,(short)8,(short)16+contador,(short)9));//NOPMD
	            	cell = row.createCell((short)10); 
	            	if(StringUtils.isNotEmpty(bean.getTotalelectores())){
	            		totalElec = totalElec+Integer.parseInt(bean.getTotalelectores());
	            		cell.setCellValue(W83bUtilidades.numero(bean.getTotalelectores()));
	            	}
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	
	            	cell = row.createCell((short)11);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)12);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)13);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)14);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)15);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)16);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)17);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)18);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)19);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)20);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	cell = row.createCell((short)21);
	            	cell.setCellStyle(estiloFilaNumero(contador,excel));
	            	
	            	if (W83bClsConstantes.codELA.equals(bean.getCodsindicato())){
	        			//ELA
	        			if (row.getCell((short)11)!=null){
	        				cell = row.getCell((short)11); 
	        			}
	        			else{
	        				cell = row.createCell((short)11); 
	        			} 
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalELA=totalELA+Integer.parseInt(bean.getNumdelegados());
	        				tELA=tELA+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tELA);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codCCOO.equals(bean.getCodsindicato())){
	        			//CCOO
	        			if (row.getCell((short)12)!=null){
	        				cell = row.getCell((short)12); 
	        			}
	        			else{
	        				cell = row.createCell((short)12); 
	        			} 
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCCOO=totalCCOO+Integer.parseInt(bean.getNumdelegados());
	        				tCCOO=tCCOO+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tCCOO);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codUGT.equals(bean.getCodsindicato())){
	        			//UGT
	        			if (row.getCell((short)13)!=null){
	        				cell = row.getCell((short)13); 
	        			}
	        			else{
	        				cell = row.createCell((short)13); 
	        			}
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalUGT=totalUGT+Integer.parseInt(bean.getNumdelegados());
	        				tUGT=tUGT+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tUGT);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codLAB.equals(bean.getCodsindicato())){
	        			//LAB
	        			if (row.getCell((short)14)!=null){
	        				cell = row.getCell((short)14); 
	        			}
	        			else{
	        				cell = row.createCell((short)14); 
	        			}
	        			
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalLAB=totalLAB+Integer.parseInt(bean.getNumdelegados());
	        				tLAB=tLAB+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tLAB);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codUSO.equals(bean.getCodsindicato())){
	        			//USO
	        			if (row.getCell((short)15)!=null){
	        				cell = row.getCell((short)15); 
	        			}
	        			else{
	        				cell = row.createCell((short)15); 
	        			}
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalUSO=totalUSO+Integer.parseInt(bean.getNumdelegados());
	        				tUSO=tUSO+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tUSO);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codCUIS.equals(bean.getCodsindicato())){
	        			//CUIS
	        			if (row.getCell((short)16)!=null){
	        				cell = row.getCell((short)16); 
	        			}
	        			else{
	        				cell = row.createCell((short)16); 
	        			} 
	        			
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCUIS=totalCUIS+Integer.parseInt(bean.getNumdelegados());
	        				tCUIS=tCUIS+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tCUIS);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codCTI.equals(bean.getCodsindicato())){
	        			//CTI
	        			if (row.getCell((short)17)!=null){
	        				cell = row.getCell((short)17); 
	        			}
	        			else{
	        				cell = row.createCell((short)17); 
	        			} 
	        			
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCTS=totalCTS+Integer.parseInt(bean.getNumdelegados());
	        				tCTS=tCTS+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tCTS);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codCSI.equals(bean.getCodsindicato())){
	        			//CSI/CSI
	        			if (row.getCell((short)18)!=null){
	        				cell = row.getCell((short)18); 
	        			}
	        			else{
	        				cell = row.createCell((short)18); 
	        			} 
	        			
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCSI=totalCSI+Integer.parseInt(bean.getNumdelegados());
	        				tCSI=tCSI+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tCSI);
	        				}
	        			}
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else if (W83bClsConstantes.codNOSIN.equals(bean.getCodsindicato())){
	        			//NO SIN
	        			if (row.getCell((short)19)!=null){
	        				cell = row.getCell((short)19); 
	        			}
	        			else{
	        				cell = row.createCell((short)19); 
	        			} 
	        			
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalNOSIN=totalNOSIN+Integer.parseInt(bean.getNumdelegados());
	        				tNOSIN=tNOSIN+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
	        					cell.setCellValue(tNOSIN);
	        				}
	        			}
	                	//cell.setCellValue(bean.getNumdelegados());
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}else{
	        			//OTROS
						if (row.getCell((short)20)!=null){
	        				cell = row.getCell((short)20); 
	        			}
	        			else{
	        				cell = row.createCell((short)20); 
	        			}
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
		        			otros=otros+Integer.parseInt(bean.getNumdelegados());
		        			total=total+Integer.parseInt(bean.getNumdelegados());
		        			totalOTROS=totalOTROS+Integer.parseInt(bean.getNumdelegados());
//	            			if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
		        				cell.setCellValue(otros);
//		        			}
	        			}else{
	        				otros=otros+0;
	            			total=total+0;
	            			totalOTROS=totalOTROS+0;
	        			}
	        			
	                	
	                	cell.setCellStyle(estiloFilaNumero(contador,excel));
	        		}
	            	
	            	acta=bean.getNacta();
	            	anno=Integer.parseInt(bean.getAnoacta());
	            	contador=contador+1;
        	}else{
        		if (W83bClsConstantes.codELA.equals(bean.getCodsindicato())){
        			//ELA
        			if (row.getCell((short)11)!=null){
        				cell = row.getCell((short)11); 
        			}
        			else{
        				cell = row.createCell((short)11); 
        			}
        			
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalELA=totalELA+Integer.parseInt(bean.getNumdelegados());
        				tELA=tELA+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tELA);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCCOO.equals(bean.getCodsindicato())){
        			//CCOO
        			if (row.getCell((short)12)!=null){
        				cell = row.getCell((short)12); 
        			}
        			else{
        				cell = row.createCell((short)12); 
        			} 
        			
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCCOO=totalCCOO+Integer.parseInt(bean.getNumdelegados());
        				tCCOO=tCCOO+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tCCOO);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codUGT.equals(bean.getCodsindicato())){
        			//UGT
        			if (row.getCell((short)13)!=null){
        				cell = row.getCell((short)13); 
        			}
        			else{
        				cell = row.createCell((short)13); 
        			}
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalUGT=totalUGT+Integer.parseInt(bean.getNumdelegados());
        				tUGT=tUGT+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tUGT);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codLAB.equals(bean.getCodsindicato())){
        			//LAB
        			if (row.getCell((short)14)!=null){
        				cell = row.getCell((short)14); 
        			}
        			else{
        				cell = row.createCell((short)14); 
        			}
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalLAB=totalLAB+Integer.parseInt(bean.getNumdelegados());
        				tLAB=tLAB+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tLAB);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codUSO.equals(bean.getCodsindicato())){
        			//USO
        			if (row.getCell((short)15)!=null){
        				cell = row.getCell((short)15); 
        			}
        			else{
        				cell = row.createCell((short)15); 
        			}
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalUSO=totalUSO+Integer.parseInt(bean.getNumdelegados());
        				tUSO=tUSO+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tUSO);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCUIS.equals(bean.getCodsindicato())){
        			//CUIS
        			if (row.getCell((short)16)!=null){
        				cell = row.getCell((short)16); 
        			}
        			else{
        				cell = row.createCell((short)16); 
        			} 
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCUIS=totalCUIS+Integer.parseInt(bean.getNumdelegados());
        				tCUIS=tCUIS+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tCUIS);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCTI.equals(bean.getCodsindicato())){
        			//CTI
        			if (row.getCell((short)17)!=null){
        				cell = row.getCell((short)17); 
        			}
        			else{
        				cell = row.createCell((short)17); 
        			}  
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCTS=totalCTS+Integer.parseInt(bean.getNumdelegados());
        				tCTS=tCTS+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tCTS);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCSI.equals(bean.getCodsindicato())){
        			//CSI/CSI
        			if (row.getCell((short)18)!=null){
        				cell = row.getCell((short)18); 
        			}
        			else{
        				cell = row.createCell((short)18); 
        			}  
        			
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCSI=totalCSI+Integer.parseInt(bean.getNumdelegados());
        				tCSI=tCSI+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tCSI);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codNOSIN.equals(bean.getCodsindicato())){
        			//NO SIN
        			if (row.getCell((short)19)!=null){
        				cell = row.getCell((short)19); 
        			}
        			else{
        				cell = row.createCell((short)19); 
        			}  
        			
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalNOSIN=totalNOSIN+Integer.parseInt(bean.getNumdelegados());
        				tNOSIN=tNOSIN+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
        					cell.setCellValue(tNOSIN);
        				}
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else{
        			//OTROS
        			if (row.getCell((short)20)!=null){
        				cell = row.getCell((short)20); 
        			}
        			else{
        				cell = row.createCell((short)20); 
        			} 
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				otros=otros+Integer.parseInt(bean.getNumdelegados());
            			total=total+Integer.parseInt(bean.getNumdelegados());
            			totalOTROS=totalOTROS+Integer.parseInt(bean.getNumdelegados());
//            			if(0!=W83bUtilidades.numero(bean.getNumdelegados())){
            				cell.setCellValue(otros);
//            			}
        			}else{
        				otros=otros+0;
            			total=total+0;
            			totalOTROS=totalOTROS+0;
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}
        	}
        	}
        	if (i==lista.size()-1){
        		cell = row.createCell((short)21); 
            	cell.setCellValue(total);
            	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        	}
        	
        }
        
        HSSFCellStyle negritaTexto = W83bClsEstilosExcel.estiloNegritaTexto(wb);
    	
        //LINEA TOTAL
        row = sheet.createRow((short)16+contador); // Creacin de la fila 1
    	
    	cell = row.createCell((short)0); 
    	sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
    	
    	cell.setCellValue("GUZTIRA/ TOTAL");
    	cell.setCellStyle(negritaTexto);
    	sheet.addMergedRegion(new Region(16+contador,Short.parseShort("0"),16+contador,Short.parseShort("9")));//NOPMD
    	cell = row.createCell((short)1); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)2); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)3); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)4); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)5); 
    	cell.setCellStyle(negritaTexto);
    	cell = row.createCell((short)6); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)7); 
    	cell.setCellStyle(negritaTexto);
    	
    	cell = row.createCell((short)8); 
    	cell.setCellStyle(negritaTexto);
    	cell = row.createCell((short)9);
    	cell.setCellStyle(negritaTexto);
    	
    	
    	
    	//cell2.setCellStyle(estiloFila(contador,excel));
    	cell = row.createCell((short)10);  
    	cell.setCellValue(totalElec);
    	cell.setCellStyle(sytleNegritaFormateado(excel));
    	
    	
    	cell = row.createCell((short)11); 
		cell.setCellValue(totalELA);
		cell.setCellStyle(sytleNegritaFormateado(excel));
    	
		cell = row.createCell((short)12); 
		cell.setCellValue(totalCCOO);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)13); 
		cell.setCellValue(totalUGT);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)14); 
		cell.setCellValue(totalLAB);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		    	
		cell = row.createCell((short)15); 
		cell.setCellValue(totalUSO);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)16); 
		cell.setCellValue(totalCUIS);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)17); 
		cell.setCellValue(totalCTS);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)18); 
		cell.setCellValue(totalCSI);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)19); 
		cell.setCellValue(totalNOSIN);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		cell = row.createCell((short)20); 
		cell.setCellValue(totalOTROS);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
		int totalTotal = totalCCOO+totalCSI+totalCTS+totalCUIS+totalELA+totalLAB+totalNOSIN+totalOTROS+totalUGT+totalUSO;
		cell = row.createCell((short)21); 
		cell.setCellValue(totalTotal);
		cell.setCellStyle(sytleNegritaFormateado(excel));
		
        
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDetalleCentroSindicato.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	private HSSFCellStyle styleCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;	
		}else{
			return excel.styleTextoImparCentrado;		
		}
				
		
	}

	private HSSFCellStyle sytleNegritaFormateado(W83bUtilidadesExcel excel){
		return excel.sytleNegritaFormateado;			
		
	}
}
